package io.burkard.cdk.services.elasticsearch

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EncryptionAtRestOptions {

  def apply(
    enabled: Option[Boolean] = None,
    kmsKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions =
    (new software.amazon.awscdk.services.elasticsearch.EncryptionAtRestOptions.Builder)
      .enabled(enabled.map(Boolean.box).orNull)
      .kmsKey(kmsKey.orNull)
      .build()
}
