package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KubernetesManifest {

  def apply(
    internalResourceId: String,
    cluster: software.amazon.awscdk.services.eks.ICluster,
    manifest: List[_ <: Map[String, _]],
    skipValidation: Option[Boolean] = None,
    ingressAlb: Option[Boolean] = None,
    prune: Option[Boolean] = None,
    overwrite: Option[Boolean] = None,
    ingressAlbScheme: Option[software.amazon.awscdk.services.eks.AlbScheme] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.eks.KubernetesManifest =
    software.amazon.awscdk.services.eks.KubernetesManifest.Builder
      .create(stackCtx, internalResourceId)
      .cluster(cluster)
      .manifest(manifest.map(_.asJava).asJava)
      .skipValidation(skipValidation.map(Boolean.box).orNull)
      .ingressAlb(ingressAlb.map(Boolean.box).orNull)
      .prune(prune.map(Boolean.box).orNull)
      .overwrite(overwrite.map(Boolean.box).orNull)
      .ingressAlbScheme(ingressAlbScheme.orNull)
      .build()
}
