package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HelmChartOptions {

  def apply(
    createNamespace: Option[Boolean] = None,
    repository: Option[String] = None,
    chartAsset: Option[software.amazon.awscdk.services.s3.assets.Asset] = None,
    version: Option[String] = None,
    chart: Option[String] = None,
    values: Option[Map[String, _]] = None,
    release: Option[String] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None,
    namespace: Option[String] = None
  ): software.amazon.awscdk.services.eks.HelmChartOptions =
    (new software.amazon.awscdk.services.eks.HelmChartOptions.Builder)
      .createNamespace(createNamespace.map(Boolean.box).orNull)
      .repository(repository.orNull)
      .chartAsset(chartAsset.orNull)
      .version(version.orNull)
      .chart(chart.orNull)
      .values(values.map(_.asJava).orNull)
      .release(release.orNull)
      .timeout(timeout.orNull)
      .namespace(namespace.orNull)
      .build()
}
