package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnService {

  def apply(
    internalResourceId: String,
    capacityProviderStrategy: Option[List[_]] = None,
    platformVersion: Option[String] = None,
    role: Option[String] = None,
    networkConfiguration: Option[software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty] = None,
    desiredCount: Option[Number] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    serviceName: Option[String] = None,
    enableExecuteCommand: Option[Boolean] = None,
    launchType: Option[String] = None,
    loadBalancers: Option[List[_]] = None,
    cluster: Option[String] = None,
    healthCheckGracePeriodSeconds: Option[Number] = None,
    propagateTags: Option[String] = None,
    enableEcsManagedTags: Option[Boolean] = None,
    deploymentConfiguration: Option[software.amazon.awscdk.services.ecs.CfnService.DeploymentConfigurationProperty] = None,
    taskDefinition: Option[String] = None,
    deploymentController: Option[software.amazon.awscdk.services.ecs.CfnService.DeploymentControllerProperty] = None,
    serviceRegistries: Option[List[_]] = None,
    placementConstraints: Option[List[_]] = None,
    placementStrategies: Option[List[_]] = None,
    schedulingStrategy: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ecs.CfnService =
    software.amazon.awscdk.services.ecs.CfnService.Builder
      .create(stackCtx, internalResourceId)
      .capacityProviderStrategy(capacityProviderStrategy.map(_.asJava).orNull)
      .platformVersion(platformVersion.orNull)
      .role(role.orNull)
      .networkConfiguration(networkConfiguration.orNull)
      .desiredCount(desiredCount.orNull)
      .tags(tags.map(_.asJava).orNull)
      .serviceName(serviceName.orNull)
      .enableExecuteCommand(enableExecuteCommand.map(Boolean.box).orNull)
      .launchType(launchType.orNull)
      .loadBalancers(loadBalancers.map(_.asJava).orNull)
      .cluster(cluster.orNull)
      .healthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds.orNull)
      .propagateTags(propagateTags.orNull)
      .enableEcsManagedTags(enableEcsManagedTags.map(Boolean.box).orNull)
      .deploymentConfiguration(deploymentConfiguration.orNull)
      .taskDefinition(taskDefinition.orNull)
      .deploymentController(deploymentController.orNull)
      .serviceRegistries(serviceRegistries.map(_.asJava).orNull)
      .placementConstraints(placementConstraints.map(_.asJava).orNull)
      .placementStrategies(placementStrategies.map(_.asJava).orNull)
      .schedulingStrategy(schedulingStrategy.orNull)
      .build()
}
