package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Subnet {

  def apply(
    internalResourceId: String,
    cidrBlock: String,
    vpcId: String,
    availabilityZone: String,
    mapPublicIpOnLaunch: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.Subnet =
    software.amazon.awscdk.services.ec2.Subnet.Builder
      .create(stackCtx, internalResourceId)
      .cidrBlock(cidrBlock)
      .vpcId(vpcId)
      .availabilityZone(availabilityZone)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .build()
}
