package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PublicSubnetAttributes {

  def apply(
    ipv4CidrBlock: Option[String] = None,
    availabilityZone: Option[String] = None,
    routeTableId: Option[String] = None,
    subnetId: Option[String] = None
  ): software.amazon.awscdk.services.ec2.PublicSubnetAttributes =
    (new software.amazon.awscdk.services.ec2.PublicSubnetAttributes.Builder)
      .ipv4CidrBlock(ipv4CidrBlock.orNull)
      .availabilityZone(availabilityZone.orNull)
      .routeTableId(routeTableId.orNull)
      .subnetId(subnetId.orNull)
      .build()
}
