package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PrivateSubnetProps {

  def apply(
    cidrBlock: Option[String] = None,
    mapPublicIpOnLaunch: Option[Boolean] = None,
    vpcId: Option[String] = None,
    availabilityZone: Option[String] = None
  ): software.amazon.awscdk.services.ec2.PrivateSubnetProps =
    (new software.amazon.awscdk.services.ec2.PrivateSubnetProps.Builder)
      .cidrBlock(cidrBlock.orNull)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .vpcId(vpcId.orNull)
      .availabilityZone(availabilityZone.orNull)
      .build()
}
