package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Instance {

  def apply(
    internalResourceId: String,
    machineImage: software.amazon.awscdk.services.ec2.IMachineImage,
    instanceType: software.amazon.awscdk.services.ec2.InstanceType,
    vpc: software.amazon.awscdk.services.ec2.IVpc,
    initOptions: Option[software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions] = None,
    propagateTagsToVolumeOnCreation: Option[Boolean] = None,
    blockDevices: Option[List[_ <: software.amazon.awscdk.services.ec2.BlockDevice]] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    userDataCausesReplacement: Option[Boolean] = None,
    userData: Option[software.amazon.awscdk.services.ec2.UserData] = None,
    availabilityZone: Option[String] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    allowAllOutbound: Option[Boolean] = None,
    resourceSignalTimeout: Option[software.amazon.awscdk.Duration] = None,
    requireImdsv2: Option[Boolean] = None,
    keyName: Option[String] = None,
    detailedMonitoring: Option[Boolean] = None,
    sourceDestCheck: Option[Boolean] = None,
    privateIpAddress: Option[String] = None,
    init: Option[software.amazon.awscdk.services.ec2.CloudFormationInit] = None,
    securityGroup: Option[software.amazon.awscdk.services.ec2.ISecurityGroup] = None,
    instanceName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.Instance =
    software.amazon.awscdk.services.ec2.Instance.Builder
      .create(stackCtx, internalResourceId)
      .machineImage(machineImage)
      .instanceType(instanceType)
      .vpc(vpc)
      .initOptions(initOptions.orNull)
      .propagateTagsToVolumeOnCreation(propagateTagsToVolumeOnCreation.map(Boolean.box).orNull)
      .blockDevices(blockDevices.map(_.asJava).orNull)
      .role(role.orNull)
      .userDataCausesReplacement(userDataCausesReplacement.map(Boolean.box).orNull)
      .userData(userData.orNull)
      .availabilityZone(availabilityZone.orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .allowAllOutbound(allowAllOutbound.map(Boolean.box).orNull)
      .resourceSignalTimeout(resourceSignalTimeout.orNull)
      .requireImdsv2(requireImdsv2.map(Boolean.box).orNull)
      .keyName(keyName.orNull)
      .detailedMonitoring(detailedMonitoring.map(Boolean.box).orNull)
      .sourceDestCheck(sourceDestCheck.map(Boolean.box).orNull)
      .privateIpAddress(privateIpAddress.orNull)
      .init(init.orNull)
      .securityGroup(securityGroup.orNull)
      .instanceName(instanceName.orNull)
      .build()
}
