package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClientVpnAuthorizationRule {

  def apply(
    internalResourceId: String,
    description: Option[String] = None,
    groupId: Option[String] = None,
    clientVpnEndpoint: Option[software.amazon.awscdk.services.ec2.IClientVpnEndpoint] = None,
    cidr: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule =
    software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRule.Builder
      .create(stackCtx, internalResourceId)
      .description(description.orNull)
      .groupId(groupId.orNull)
      .clientVpnEndpoint(clientVpnEndpoint.orNull)
      .cidr(cidr.orNull)
      .build()
}
