package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVPCCidrBlock {

  def apply(
    internalResourceId: String,
    vpcId: String,
    amazonProvidedIpv6CidrBlock: Option[Boolean] = None,
    ipv4NetmaskLength: Option[Number] = None,
    ipv6NetmaskLength: Option[Number] = None,
    ipv6Pool: Option[String] = None,
    ipv6IpamPoolId: Option[String] = None,
    cidrBlock: Option[String] = None,
    ipv6CidrBlock: Option[String] = None,
    ipv4IpamPoolId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnVPCCidrBlock =
    software.amazon.awscdk.services.ec2.CfnVPCCidrBlock.Builder
      .create(stackCtx, internalResourceId)
      .vpcId(vpcId)
      .amazonProvidedIpv6CidrBlock(amazonProvidedIpv6CidrBlock.map(Boolean.box).orNull)
      .ipv4NetmaskLength(ipv4NetmaskLength.orNull)
      .ipv6NetmaskLength(ipv6NetmaskLength.orNull)
      .ipv6Pool(ipv6Pool.orNull)
      .ipv6IpamPoolId(ipv6IpamPoolId.orNull)
      .cidrBlock(cidrBlock.orNull)
      .ipv6CidrBlock(ipv6CidrBlock.orNull)
      .ipv4IpamPoolId(ipv4IpamPoolId.orNull)
      .build()
}
