package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTransitGatewayAttachment {

  def apply(
    internalResourceId: String,
    transitGatewayId: String,
    vpcId: String,
    subnetIds: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnTransitGatewayAttachment =
    software.amazon.awscdk.services.ec2.CfnTransitGatewayAttachment.Builder
      .create(stackCtx, internalResourceId)
      .transitGatewayId(transitGatewayId)
      .vpcId(vpcId)
      .subnetIds(subnetIds.asJava)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
