package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNetworkInterfaceAttachmentProps {

  def apply(
    networkInterfaceId: String,
    deviceIndex: String,
    instanceId: String,
    deleteOnTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachmentProps =
    (new software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachmentProps.Builder)
      .networkInterfaceId(networkInterfaceId)
      .deviceIndex(deviceIndex)
      .instanceId(instanceId)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
