package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNetworkInterfaceAttachment {

  def apply(
    internalResourceId: String,
    networkInterfaceId: String,
    deviceIndex: String,
    instanceId: String,
    deleteOnTermination: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachment =
    software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachment.Builder
      .create(stackCtx, internalResourceId)
      .networkInterfaceId(networkInterfaceId)
      .deviceIndex(deviceIndex)
      .instanceId(instanceId)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
