package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AclTrafficConfig {

  def apply(
    protocol: Number,
    icmp: Option[software.amazon.awscdk.services.ec2.AclIcmp] = None,
    portRange: Option[software.amazon.awscdk.services.ec2.AclPortRange] = None
  ): software.amazon.awscdk.services.ec2.AclTrafficConfig =
    (new software.amazon.awscdk.services.ec2.AclTrafficConfig.Builder)
      .protocol(protocol)
      .icmp(icmp.orNull)
      .portRange(portRange.orNull)
      .build()
}
