package io.burkard.cdk.services.dms.cfnEndpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PostgreSqlSettingsProperty {

  def apply(
    heartbeatSchema: Option[String] = None,
    executeTimeout: Option[Number] = None,
    ddlArtifactsSchema: Option[String] = None,
    captureDdls: Option[Boolean] = None,
    heartbeatFrequency: Option[Number] = None,
    secretsManagerAccessRoleArn: Option[String] = None,
    secretsManagerSecretId: Option[String] = None,
    afterConnectScript: Option[String] = None,
    heartbeatEnable: Option[Boolean] = None,
    pluginName: Option[String] = None,
    failTasksOnLobTruncation: Option[Boolean] = None,
    maxFileSize: Option[Number] = None,
    slotName: Option[String] = None
  ): software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty =
    (new software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty.Builder)
      .heartbeatSchema(heartbeatSchema.orNull)
      .executeTimeout(executeTimeout.orNull)
      .ddlArtifactsSchema(ddlArtifactsSchema.orNull)
      .captureDdls(captureDdls.map(Boolean.box).orNull)
      .heartbeatFrequency(heartbeatFrequency.orNull)
      .secretsManagerAccessRoleArn(secretsManagerAccessRoleArn.orNull)
      .secretsManagerSecretId(secretsManagerSecretId.orNull)
      .afterConnectScript(afterConnectScript.orNull)
      .heartbeatEnable(heartbeatEnable.map(Boolean.box).orNull)
      .pluginName(pluginName.orNull)
      .failTasksOnLobTruncation(failTasksOnLobTruncation.map(Boolean.box).orNull)
      .maxFileSize(maxFileSize.orNull)
      .slotName(slotName.orNull)
      .build()
}
