package io.burkard.cdk.services.dms

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnReplicationTaskProps {

  def apply(
    sourceEndpointArn: String,
    replicationInstanceArn: String,
    targetEndpointArn: String,
    tableMappings: String,
    migrationType: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    taskData: Option[String] = None,
    replicationTaskIdentifier: Option[String] = None,
    replicationTaskSettings: Option[String] = None,
    cdcStartTime: Option[Number] = None,
    cdcStopPosition: Option[String] = None,
    resourceIdentifier: Option[String] = None,
    cdcStartPosition: Option[String] = None
  ): software.amazon.awscdk.services.dms.CfnReplicationTaskProps =
    (new software.amazon.awscdk.services.dms.CfnReplicationTaskProps.Builder)
      .sourceEndpointArn(sourceEndpointArn)
      .replicationInstanceArn(replicationInstanceArn)
      .targetEndpointArn(targetEndpointArn)
      .tableMappings(tableMappings)
      .migrationType(migrationType)
      .tags(tags.map(_.asJava).orNull)
      .taskData(taskData.orNull)
      .replicationTaskIdentifier(replicationTaskIdentifier.orNull)
      .replicationTaskSettings(replicationTaskSettings.orNull)
      .cdcStartTime(cdcStartTime.orNull)
      .cdcStopPosition(cdcStopPosition.orNull)
      .resourceIdentifier(resourceIdentifier.orNull)
      .cdcStartPosition(cdcStartPosition.orNull)
      .build()
}
