package io.burkard.cdk.services.directoryservice

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSimpleAD {

  def apply(
    internalResourceId: String,
    name: String,
    size: String,
    vpcSettings: software.amazon.awscdk.services.directoryservice.CfnSimpleAD.VpcSettingsProperty,
    password: String,
    description: Option[String] = None,
    createAlias: Option[Boolean] = None,
    enableSso: Option[Boolean] = None,
    shortName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.directoryservice.CfnSimpleAD =
    software.amazon.awscdk.services.directoryservice.CfnSimpleAD.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .size(size)
      .vpcSettings(vpcSettings)
      .password(password)
      .description(description.orNull)
      .createAlias(createAlias.map(Boolean.box).orNull)
      .enableSso(enableSso.map(Boolean.box).orNull)
      .shortName(shortName.orNull)
      .build()
}
