package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfig {

  def apply(
    internalResourceId: String,
    deploymentConfigName: Option[String] = None,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None,
    computePlatform: Option[String] = None,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig =
    software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.Builder
      .create(stackCtx, internalResourceId)
      .deploymentConfigName(deploymentConfigName.orNull)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .computePlatform(computePlatform.orNull)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .build()
}
