package io.burkard.cdk.services.cloudwatch

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CompositeAlarmProps {

  def apply(
    alarmRule: software.amazon.awscdk.services.cloudwatch.IAlarmRule,
    compositeAlarmName: Option[String] = None,
    actionsEnabled: Option[Boolean] = None,
    alarmDescription: Option[String] = None
  ): software.amazon.awscdk.services.cloudwatch.CompositeAlarmProps =
    (new software.amazon.awscdk.services.cloudwatch.CompositeAlarmProps.Builder)
      .alarmRule(alarmRule)
      .compositeAlarmName(compositeAlarmName.orNull)
      .actionsEnabled(actionsEnabled.map(Boolean.box).orNull)
      .alarmDescription(alarmDescription.orNull)
      .build()
}
