package io.burkard.cdk.services.cloudfront

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResponseHeadersCorsBehavior {

  def apply(
    originOverride: Boolean,
    accessControlAllowMethods: List[String],
    accessControlAllowOrigins: List[String],
    accessControlAllowHeaders: List[String],
    accessControlAllowCredentials: Boolean,
    accessControlExposeHeaders: Option[List[String]] = None,
    accessControlMaxAge: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior =
    (new software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior.Builder)
      .originOverride(originOverride)
      .accessControlAllowMethods(accessControlAllowMethods.asJava)
      .accessControlAllowOrigins(accessControlAllowOrigins.asJava)
      .accessControlAllowHeaders(accessControlAllowHeaders.asJava)
      .accessControlAllowCredentials(accessControlAllowCredentials)
      .accessControlExposeHeaders(accessControlExposeHeaders.map(_.asJava).orNull)
      .accessControlMaxAge(accessControlMaxAge.orNull)
      .build()
}
