package io.burkard.cdk.services.billingconductor

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPricingRuleProps {

  def apply(
    modifierPercentage: Number,
    name: String,
    scope: String,
    `type`: String,
    description: Option[String] = None,
    service: Option[String] = None
  ): software.amazon.awscdk.services.billingconductor.CfnPricingRuleProps =
    (new software.amazon.awscdk.services.billingconductor.CfnPricingRuleProps.Builder)
      .modifierPercentage(modifierPercentage)
      .name(name)
      .scope(scope)
      .`type`(`type`)
      .description(description.orNull)
      .service(service.orNull)
      .build()
}
