package io.burkard.cdk.services.billingconductor

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBillingGroupProps {

  def apply(
    name: String,
    primaryAccountId: String,
    accountGrouping: software.amazon.awscdk.services.billingconductor.CfnBillingGroup.AccountGroupingProperty,
    computationPreference: software.amazon.awscdk.services.billingconductor.CfnBillingGroup.ComputationPreferenceProperty,
    description: Option[String] = None
  ): software.amazon.awscdk.services.billingconductor.CfnBillingGroupProps =
    (new software.amazon.awscdk.services.billingconductor.CfnBillingGroupProps.Builder)
      .name(name)
      .primaryAccountId(primaryAccountId)
      .accountGrouping(accountGrouping)
      .computationPreference(computationPreference)
      .description(description.orNull)
      .build()
}
