package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WarmPoolProps {

  def apply(
    autoScalingGroup: software.amazon.awscdk.services.autoscaling.IAutoScalingGroup,
    maxGroupPreparedCapacity: Option[Number] = None,
    reuseOnScaleIn: Option[Boolean] = None,
    poolState: Option[software.amazon.awscdk.services.autoscaling.PoolState] = None,
    minSize: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.WarmPoolProps =
    (new software.amazon.awscdk.services.autoscaling.WarmPoolProps.Builder)
      .autoScalingGroup(autoScalingGroup)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .reuseOnScaleIn(reuseOnScaleIn.map(Boolean.box).orNull)
      .poolState(poolState.orNull)
      .minSize(minSize.orNull)
      .build()
}
