package io.burkard.cdk.services.autoscaling

sealed abstract class PoolState(val underlying: software.amazon.awscdk.services.autoscaling.PoolState)
  extends Product
    with Serializable

object PoolState {
  implicit def toAws(value: PoolState): software.amazon.awscdk.services.autoscaling.PoolState =
    Option(value).map(_.underlying).orNull

  case object Hibernated
    extends PoolState(software.amazon.awscdk.services.autoscaling.PoolState.HIBERNATED)

  case object Running
    extends PoolState(software.amazon.awscdk.services.autoscaling.PoolState.RUNNING)

  case object Stopped
    extends PoolState(software.amazon.awscdk.services.autoscaling.PoolState.STOPPED)
}
