package io.burkard.cdk.services.autoscaling

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApplyCloudFormationInitOptions {

  def apply(
    embedFingerprint: Option[Boolean] = None,
    ignoreFailures: Option[Boolean] = None,
    includeRole: Option[Boolean] = None,
    printLog: Option[Boolean] = None,
    includeUrl: Option[Boolean] = None,
    configSets: Option[List[String]] = None
  ): software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions =
    (new software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions.Builder)
      .embedFingerprint(embedFingerprint.map(Boolean.box).orNull)
      .ignoreFailures(ignoreFailures.map(Boolean.box).orNull)
      .includeRole(includeRole.map(Boolean.box).orNull)
      .printLog(printLog.map(Boolean.box).orNull)
      .includeUrl(includeUrl.map(Boolean.box).orNull)
      .configSets(configSets.map(_.asJava).orNull)
      .build()
}
