package io.burkard.cdk.services.appstream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationEntitlementAssociation {

  def apply(
    internalResourceId: String,
    entitlementName: String,
    stackName: String,
    applicationIdentifier: String
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appstream.CfnApplicationEntitlementAssociation =
    software.amazon.awscdk.services.appstream.CfnApplicationEntitlementAssociation.Builder
      .create(stackCtx, internalResourceId)
      .entitlementName(entitlementName)
      .stackName(stackName)
      .applicationIdentifier(applicationIdentifier)
      .build()
}
