package io.burkard.cdk.services.appintegrations

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataIntegration {

  def apply(
    internalResourceId: String,
    name: String,
    kmsKey: String,
    sourceUri: String,
    scheduleConfig: software.amazon.awscdk.services.appintegrations.CfnDataIntegration.ScheduleConfigProperty,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appintegrations.CfnDataIntegration =
    software.amazon.awscdk.services.appintegrations.CfnDataIntegration.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .kmsKey(kmsKey)
      .sourceUri(sourceUri)
      .scheduleConfig(scheduleConfig)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
