package io.burkard.cdk.services.appflow.cfnConnectorProfile

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MarketoConnectorProfileCredentialsProperty {

  def apply(
    clientId: String,
    clientSecret: String,
    accessToken: Option[String] = None,
    connectorOAuthRequest: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty] = None
  ): software.amazon.awscdk.services.appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty =
    (new software.amazon.awscdk.services.appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty.Builder)
      .clientId(clientId)
      .clientSecret(clientSecret)
      .accessToken(accessToken.orNull)
      .connectorOAuthRequest(connectorOAuthRequest.orNull)
      .build()
}
