package io.burkard.cdk.services.apigatewayv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApiMappingProps {

  def apply(
    stage: String,
    apiId: String,
    domainName: String,
    apiMappingKey: Option[String] = None
  ): software.amazon.awscdk.services.apigatewayv2.CfnApiMappingProps =
    (new software.amazon.awscdk.services.apigatewayv2.CfnApiMappingProps.Builder)
      .stage(stage)
      .apiId(apiId)
      .domainName(domainName)
      .apiMappingKey(apiMappingKey.orNull)
      .build()
}
