package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestValidatorOptions {

  def apply(
    requestValidatorName: Option[String] = None,
    validateRequestBody: Option[Boolean] = None,
    validateRequestParameters: Option[Boolean] = None
  ): software.amazon.awscdk.services.apigateway.RequestValidatorOptions =
    (new software.amazon.awscdk.services.apigateway.RequestValidatorOptions.Builder)
      .requestValidatorName(requestValidatorName.orNull)
      .validateRequestBody(validateRequestBody.map(Boolean.box).orNull)
      .validateRequestParameters(validateRequestParameters.map(Boolean.box).orNull)
      .build()
}
