package io.burkard.cdk.services.amplifyuibuilder.cfnComponent

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ComponentChildProperty {

  def apply(
    name: String,
    componentType: String,
    properties: AnyRef,
    children: Option[List[_]] = None,
    events: Option[AnyRef] = None
  ): software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentChildProperty =
    (new software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentChildProperty.Builder)
      .name(name)
      .componentType(componentType)
      .properties(properties)
      .children(children.map(_.asJava).orNull)
      .events(events.orNull)
      .build()
}
