package io.burkard.cdk.cloudassembly.schema

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object IntegManifest {

  def apply(
    version: String,
    testCases: Map[String, _ <: software.amazon.awscdk.cloudassembly.schema.TestCase],
    enableLookups: Option[Boolean] = None
  ): software.amazon.awscdk.cloudassembly.schema.IntegManifest =
    (new software.amazon.awscdk.cloudassembly.schema.IntegManifest.Builder)
      .version(version)
      .testCases(testCases.asJava)
      .enableLookups(enableLookups.map(Boolean.box).orNull)
      .build()
}
