package io.burkard.cdk.cloudassembly.schema

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Hooks {

  def apply(
    postDeploy: Option[List[String]] = None,
    postDestroy: Option[List[String]] = None,
    preDeploy: Option[List[String]] = None,
    preDestroy: Option[List[String]] = None
  ): software.amazon.awscdk.cloudassembly.schema.Hooks =
    (new software.amazon.awscdk.cloudassembly.schema.Hooks.Builder)
      .postDeploy(postDeploy.map(_.asJava).orNull)
      .postDestroy(postDestroy.map(_.asJava).orNull)
      .preDeploy(preDeploy.map(_.asJava).orNull)
      .preDestroy(preDestroy.map(_.asJava).orNull)
      .build()
}
