package io.burkard.cdk.cloudassembly.schema

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DeployOptions {

  def apply(
    reuseAssets: Option[List[String]] = None,
    staging: Option[Boolean] = None,
    strict: Option[Boolean] = None,
    execute: Option[Boolean] = None,
    force: Option[Boolean] = None,
    assetMetadata: Option[Boolean] = None,
    trace: Option[Boolean] = None,
    toolkitStackName: Option[String] = None,
    verbose: Option[Boolean] = None,
    json: Option[Boolean] = None,
    all: Option[Boolean] = None,
    context: Option[Map[String, String]] = None,
    ec2Creds: Option[Boolean] = None,
    requireApproval: Option[software.amazon.awscdk.cloudassembly.schema.RequireApproval] = None,
    color: Option[Boolean] = None,
    stacks: Option[List[String]] = None,
    pathMetadata: Option[Boolean] = None,
    caBundlePath: Option[String] = None,
    debug: Option[Boolean] = None,
    notificationArns: Option[List[String]] = None,
    rollback: Option[Boolean] = None,
    profile: Option[String] = None,
    usePreviousParameters: Option[Boolean] = None,
    exclusively: Option[Boolean] = None,
    versionReporting: Option[Boolean] = None,
    ignoreErrors: Option[Boolean] = None,
    roleArn: Option[String] = None,
    proxy: Option[String] = None,
    ci: Option[Boolean] = None,
    app: Option[String] = None,
    output: Option[String] = None,
    notices: Option[Boolean] = None,
    outputsFile: Option[String] = None,
    changeSetName: Option[String] = None,
    lookups: Option[Boolean] = None,
    parameters: Option[Map[String, String]] = None
  ): software.amazon.awscdk.cloudassembly.schema.DeployOptions =
    (new software.amazon.awscdk.cloudassembly.schema.DeployOptions.Builder)
      .reuseAssets(reuseAssets.map(_.asJava).orNull)
      .staging(staging.map(Boolean.box).orNull)
      .strict(strict.map(Boolean.box).orNull)
      .execute(execute.map(Boolean.box).orNull)
      .force(force.map(Boolean.box).orNull)
      .assetMetadata(assetMetadata.map(Boolean.box).orNull)
      .trace(trace.map(Boolean.box).orNull)
      .toolkitStackName(toolkitStackName.orNull)
      .verbose(verbose.map(Boolean.box).orNull)
      .json(json.map(Boolean.box).orNull)
      .all(all.map(Boolean.box).orNull)
      .context(context.map(_.asJava).orNull)
      .ec2Creds(ec2Creds.map(Boolean.box).orNull)
      .requireApproval(requireApproval.orNull)
      .color(color.map(Boolean.box).orNull)
      .stacks(stacks.map(_.asJava).orNull)
      .pathMetadata(pathMetadata.map(Boolean.box).orNull)
      .caBundlePath(caBundlePath.orNull)
      .debug(debug.map(Boolean.box).orNull)
      .notificationArns(notificationArns.map(_.asJava).orNull)
      .rollback(rollback.map(Boolean.box).orNull)
      .profile(profile.orNull)
      .usePreviousParameters(usePreviousParameters.map(Boolean.box).orNull)
      .exclusively(exclusively.map(Boolean.box).orNull)
      .versionReporting(versionReporting.map(Boolean.box).orNull)
      .ignoreErrors(ignoreErrors.map(Boolean.box).orNull)
      .roleArn(roleArn.orNull)
      .proxy(proxy.orNull)
      .ci(ci.map(Boolean.box).orNull)
      .app(app.orNull)
      .output(output.orNull)
      .notices(notices.map(Boolean.box).orNull)
      .outputsFile(outputsFile.orNull)
      .changeSetName(changeSetName.orNull)
      .lookups(lookups.map(Boolean.box).orNull)
      .parameters(parameters.map(_.asJava).orNull)
      .build()
}
