package io.burkard.cdk.cloudassembly.schema

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CdkCommand {

  def apply(
    enabled: Option[Boolean] = None,
    expectedMessage: Option[String] = None,
    expectError: Option[Boolean] = None
  ): software.amazon.awscdk.cloudassembly.schema.CdkCommand =
    (new software.amazon.awscdk.cloudassembly.schema.CdkCommand.Builder)
      .enabled(enabled.map(Boolean.box).orNull)
      .expectedMessage(expectedMessage.orNull)
      .expectError(expectError.map(Boolean.box).orNull)
      .build()
}
