package io.burkard.cdk.services.wisdom

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAssistantAssociationProps {

  def apply(
    association: software.amazon.awscdk.services.wisdom.CfnAssistantAssociation.AssociationDataProperty,
    assistantId: String,
    associationType: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.wisdom.CfnAssistantAssociationProps =
    (new software.amazon.awscdk.services.wisdom.CfnAssistantAssociationProps.Builder)
      .association(association)
      .assistantId(assistantId)
      .associationType(associationType)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
