package io.burkard.cdk.services.rds

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InstanceProps {

  def apply(
    vpc: software.amazon.awscdk.services.ec2.IVpc,
    performanceInsightEncryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    instanceType: Option[software.amazon.awscdk.services.ec2.InstanceType] = None,
    parameterGroup: Option[software.amazon.awscdk.services.rds.IParameterGroup] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    allowMajorVersionUpgrade: Option[Boolean] = None,
    deleteAutomatedBackups: Option[Boolean] = None,
    performanceInsightRetention: Option[software.amazon.awscdk.services.rds.PerformanceInsightRetention] = None,
    securityGroups: Option[List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup]] = None,
    publiclyAccessible: Option[Boolean] = None,
    parameters: Option[Map[String, String]] = None,
    enablePerformanceInsights: Option[Boolean] = None
  ): software.amazon.awscdk.services.rds.InstanceProps =
    (new software.amazon.awscdk.services.rds.InstanceProps.Builder)
      .vpc(vpc)
      .performanceInsightEncryptionKey(performanceInsightEncryptionKey.orNull)
      .autoMinorVersionUpgrade(autoMinorVersionUpgrade.map(Boolean.box).orNull)
      .instanceType(instanceType.orNull)
      .parameterGroup(parameterGroup.orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .allowMajorVersionUpgrade(allowMajorVersionUpgrade.map(Boolean.box).orNull)
      .deleteAutomatedBackups(deleteAutomatedBackups.map(Boolean.box).orNull)
      .performanceInsightRetention(performanceInsightRetention.orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .publiclyAccessible(publiclyAccessible.map(Boolean.box).orNull)
      .parameters(parameters.map(_.asJava).orNull)
      .enablePerformanceInsights(enablePerformanceInsights.map(Boolean.box).orNull)
      .build()
}
