package io.burkard.cdk.services.kendra.cfnDataSource

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DocumentAttributeValueProperty {

  def apply(
    longValue: Option[Number] = None,
    stringValue: Option[String] = None,
    stringListValue: Option[List[String]] = None,
    dateValue: Option[String] = None
  ): software.amazon.awscdk.services.kendra.CfnDataSource.DocumentAttributeValueProperty =
    (new software.amazon.awscdk.services.kendra.CfnDataSource.DocumentAttributeValueProperty.Builder)
      .longValue(longValue.orNull)
      .stringValue(stringValue.orNull)
      .stringListValue(stringListValue.map(_.asJava).orNull)
      .dateValue(dateValue.orNull)
      .build()
}
