package io.burkard.cdk.services.fsx

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileSystemAttributes {

  def apply(
    securityGroup: software.amazon.awscdk.services.ec2.ISecurityGroup,
    fileSystemId: String,
    dnsName: String
  ): software.amazon.awscdk.services.fsx.FileSystemAttributes =
    (new software.amazon.awscdk.services.fsx.FileSystemAttributes.Builder)
      .securityGroup(securityGroup)
      .fileSystemId(fileSystemId)
      .dnsName(dnsName)
      .build()
}
