package io.burkard.cdk.services.elasticsearch

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsOptions {

  def apply(
    enabled: Option[Boolean] = None,
    volumeSize: Option[Number] = None,
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.elasticsearch.EbsOptions =
    (new software.amazon.awscdk.services.elasticsearch.EbsOptions.Builder)
      .enabled(enabled.map(Boolean.box).orNull)
      .volumeSize(volumeSize.orNull)
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
