package io.burkard.cdk.services.efs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFileSystem {

  def apply(
    internalResourceId: String,
    backupPolicy: Option[software.amazon.awscdk.services.efs.CfnFileSystem.BackupPolicyProperty] = None,
    bypassPolicyLockoutSafetyCheck: Option[Boolean] = None,
    performanceMode: Option[String] = None,
    encrypted: Option[Boolean] = None,
    fileSystemPolicy: Option[AnyRef] = None,
    availabilityZoneName: Option[String] = None,
    provisionedThroughputInMibps: Option[Number] = None,
    lifecyclePolicies: Option[List[_]] = None,
    fileSystemTags: Option[List[_ <: software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty]] = None,
    throughputMode: Option[String] = None,
    kmsKeyId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.efs.CfnFileSystem =
    software.amazon.awscdk.services.efs.CfnFileSystem.Builder
      .create(stackCtx, internalResourceId)
      .backupPolicy(backupPolicy.orNull)
      .bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck.map(Boolean.box).orNull)
      .performanceMode(performanceMode.orNull)
      .encrypted(encrypted.map(Boolean.box).orNull)
      .fileSystemPolicy(fileSystemPolicy.orNull)
      .availabilityZoneName(availabilityZoneName.orNull)
      .provisionedThroughputInMibps(provisionedThroughputInMibps.orNull)
      .lifecyclePolicies(lifecyclePolicies.map(_.asJava).orNull)
      .fileSystemTags(fileSystemTags.map(_.asJava).orNull)
      .throughputMode(throughputMode.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
