package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LaunchTemplate {

  def apply(
    internalResourceId: String,
    ebsOptimized: Option[Boolean] = None,
    blockDevices: Option[List[_ <: software.amazon.awscdk.services.ec2.BlockDevice]] = None,
    disableApiTermination: Option[Boolean] = None,
    hibernationConfigured: Option[Boolean] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    machineImage: Option[software.amazon.awscdk.services.ec2.IMachineImage] = None,
    userData: Option[software.amazon.awscdk.services.ec2.UserData] = None,
    nitroEnclaveEnabled: Option[Boolean] = None,
    instanceType: Option[software.amazon.awscdk.services.ec2.InstanceType] = None,
    spotOptions: Option[software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions] = None,
    cpuCredits: Option[software.amazon.awscdk.services.ec2.CpuCredits] = None,
    requireImdsv2: Option[Boolean] = None,
    launchTemplateName: Option[String] = None,
    keyName: Option[String] = None,
    detailedMonitoring: Option[Boolean] = None,
    instanceInitiatedShutdownBehavior: Option[software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior] = None,
    securityGroup: Option[software.amazon.awscdk.services.ec2.ISecurityGroup] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.LaunchTemplate =
    software.amazon.awscdk.services.ec2.LaunchTemplate.Builder
      .create(stackCtx, internalResourceId)
      .ebsOptimized(ebsOptimized.map(Boolean.box).orNull)
      .blockDevices(blockDevices.map(_.asJava).orNull)
      .disableApiTermination(disableApiTermination.map(Boolean.box).orNull)
      .hibernationConfigured(hibernationConfigured.map(Boolean.box).orNull)
      .role(role.orNull)
      .machineImage(machineImage.orNull)
      .userData(userData.orNull)
      .nitroEnclaveEnabled(nitroEnclaveEnabled.map(Boolean.box).orNull)
      .instanceType(instanceType.orNull)
      .spotOptions(spotOptions.orNull)
      .cpuCredits(cpuCredits.orNull)
      .requireImdsv2(requireImdsv2.map(Boolean.box).orNull)
      .launchTemplateName(launchTemplateName.orNull)
      .keyName(keyName.orNull)
      .detailedMonitoring(detailedMonitoring.map(Boolean.box).orNull)
      .instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.orNull)
      .securityGroup(securityGroup.orNull)
      .build()
}
