package io.burkard.cdk.services.datasync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocationFSxWindowsProps {

  def apply(
    securityGroupArns: List[String],
    fsxFilesystemArn: String,
    user: String,
    password: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    domain: Option[String] = None,
    subdirectory: Option[String] = None
  ): software.amazon.awscdk.services.datasync.CfnLocationFSxWindowsProps =
    (new software.amazon.awscdk.services.datasync.CfnLocationFSxWindowsProps.Builder)
      .securityGroupArns(securityGroupArns.asJava)
      .fsxFilesystemArn(fsxFilesystemArn)
      .user(user)
      .password(password)
      .tags(tags.map(_.asJava).orNull)
      .domain(domain.orNull)
      .subdirectory(subdirectory.orNull)
      .build()
}
