package io.burkard.cdk.services.billingconductor

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCustomLineItemProps {

  def apply(
    name: String,
    billingGroupArn: String,
    customLineItemChargeDetails: Option[software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty] = None,
    description: Option[String] = None,
    billingPeriodRange: Option[software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty] = None
  ): software.amazon.awscdk.services.billingconductor.CfnCustomLineItemProps =
    (new software.amazon.awscdk.services.billingconductor.CfnCustomLineItemProps.Builder)
      .name(name)
      .billingGroupArn(billingGroupArn)
      .customLineItemChargeDetails(customLineItemChargeDetails.orNull)
      .description(description.orNull)
      .billingPeriodRange(billingPeriodRange.orNull)
      .build()
}
