package io.burkard.cdk.services.autoscaling.cfnScalingPolicy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricDataQueryProperty {

  def apply(
    id: String,
    label: Option[String] = None,
    returnData: Option[Boolean] = None,
    metricStat: Option[software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.MetricStatProperty] = None,
    expression: Option[String] = None
  ): software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.MetricDataQueryProperty =
    (new software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.MetricDataQueryProperty.Builder)
      .id(id)
      .label(label.orNull)
      .returnData(returnData.map(Boolean.box).orNull)
      .metricStat(metricStat.orNull)
      .expression(expression.orNull)
      .build()
}
