package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WarmPoolOptions {

  def apply(
    reuseOnScaleIn: Option[Boolean] = None,
    maxGroupPreparedCapacity: Option[Number] = None,
    poolState: Option[software.amazon.awscdk.services.autoscaling.PoolState] = None,
    minSize: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.WarmPoolOptions =
    (new software.amazon.awscdk.services.autoscaling.WarmPoolOptions.Builder)
      .reuseOnScaleIn(reuseOnScaleIn.map(Boolean.box).orNull)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .poolState(poolState.orNull)
      .minSize(minSize.orNull)
      .build()
}
