package io.burkard.cdk.services.athena

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPreparedStatement {

  def apply(
    internalResourceId: String,
    queryStatement: String,
    statementName: String,
    workGroup: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.athena.CfnPreparedStatement =
    software.amazon.awscdk.services.athena.CfnPreparedStatement.Builder
      .create(stackCtx, internalResourceId)
      .queryStatement(queryStatement)
      .statementName(statementName)
      .workGroup(workGroup)
      .description(description.orNull)
      .build()
}
