package io.burkard.cdk.services.appsync

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDomainNameProps {

  def apply(
    certificateArn: String,
    domainName: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.appsync.CfnDomainNameProps =
    (new software.amazon.awscdk.services.appsync.CfnDomainNameProps.Builder)
      .certificateArn(certificateArn)
      .domainName(domainName)
      .description(description.orNull)
      .build()
}
