package io.burkard.cdk.services.appsync

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApiKey {

  def apply(
    internalResourceId: String,
    apiId: String,
    description: Option[String] = None,
    apiKeyId: Option[String] = None,
    expires: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appsync.CfnApiKey =
    software.amazon.awscdk.services.appsync.CfnApiKey.Builder
      .create(stackCtx, internalResourceId)
      .apiId(apiId)
      .description(description.orNull)
      .apiKeyId(apiKeyId.orNull)
      .expires(expires.orNull)
      .build()
}
