package io.burkard.cdk.services.apigatewayv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnModelProps {

  def apply(
    name: String,
    schema: AnyRef,
    apiId: String,
    description: Option[String] = None,
    contentType: Option[String] = None
  ): software.amazon.awscdk.services.apigatewayv2.CfnModelProps =
    (new software.amazon.awscdk.services.apigatewayv2.CfnModelProps.Builder)
      .name(name)
      .schema(schema)
      .apiId(apiId)
      .description(description.orNull)
      .contentType(contentType.orNull)
      .build()
}
